import { View, Text, Image, FlatList } from "react-native";
import React from "react";
import styles from "./ProductReviewsItemStyles";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";
import CustomRating from "../../../screens/Utilities/CustomRating/CustomRating";
import ProgressiveImage from "../ProgressiveImage";

const ProductReviewsItem = ({ item }) => {
    const AnonymousUserImg = require("../../../assets/images/anonymous-user.png");
    const renderItem = ({ item }) => {
        return <ProgressiveImage source={{ uri: item }} style={styles.image} />
    };
    return (
        <View>
            <View style={styles.userProfile}>
                <View style={styles.userProfileSubDesc}>
                    {item?.user_image ? (
                        <ProgressiveImage
                            source={{ uri: item?.user_image }}
                            style={[styles.image, styles.imageBorderRadius]}
                        />
                    ) : (
                        <ProgressiveImage
                            style={styles.image}
                            source={AnonymousUserImg}
                        />
                    )}
                    <View>
                        <Text style={styles.userName}>{item?.user_name ? item?.user_name : 'Anonymous User'}</Text>
                        <Text style={styles.time}>{item?.created_at}</Text>
                    </View>
                </View>
                <CustomRating rating={item?.rating} starSize={dpr(13)} />
            </View>
            <Text style={styles.userProfileDesc}>{item.comments}</Text>
            {item?.vendor_replay && (
                <View style={styles.respond}>
                    <Text style={styles.userName}>
                        {item?.vendor_replay.name} responded:
                    </Text>
                    <Text style={styles.respondDesc}>
                        {item?.vendor_replay.message}
                    </Text>
                </View>
            )}
            <View>
                {
                    item?.image?.length > 0 && (
                        <FlatList
                            horizontal
                            data={item?.image}
                            renderItem={renderItem}
                            keyExtractor={(_, idx) => "n" + idx.toString()}
                            showsVerticalScrollIndicator={false}
                            showsHorizontalScrollIndicator={false}
                        />
                    )
                }
            </View>
        </View>
    );
};

export default ProductReviewsItem;
